function [ deltad,cd,nd ] = derspl( d,delta,c )
%Compute coefficients and ext knot seq for derivative spline.
%   d is the dimension of polynomials.  delta is the ext knot sequence
%   associtated to the partition.  c is the row coefficient vector on the
%   corresponding spline basis. deltad is the extended knot sequence for
%   the derivative. cd are the derivatives corresponding coefficients. nd
%   is the dimension of that spline space S^rm1_dm1.

gross = size(delta,2); %How many (padded) nodes in extended knot sequence
deltad = delta(1,2:gross - 1); %The derivative extended knot sequence.

nd = gross-d-2; %Dimension of derivative spline space.
                %gross-d-2 = (n+d+1)-d-2 = n-1

cd = zeros(1,nd);
for i=1:nd
    if delta(1,i+d+1) - delta(1,i+1) == 0
        cd(1,i) = 0;
    else
        cd(1,i) = d*(c(1,i+1)-c(1,i))/(delta(1,i+d+1) - delta(1,i+1));
    end
end


end

